<?php

class Blog_controlador{

    private $db_blog;
    private $registros_por_pagina = 3;

    // Cargamos el modelo por defecto cuando se instancie el objeto
    function __construct() {
        require_once("modelo/blog_modelo.php");
        $this->db_blog=new Blog_modelo();
        $this->db_blog->conecta();
    }

    // Definimos la acción por defecto si no se recibe otra
    public function default() {
        $this->mostrar_blog();
    }

    /**
     * Muestra todas las entradas del blog
     */
    public function mostrar_blog() {
        

        if( isset($_GET['pagina']) ){
            if(!empty($_GET['pagina'])) {
                $pagina = $_GET['pagina'];
            }
        }
        if( !isset($pagina) ) {
            $pagina = 0;
        }
        
        $total_registros=$this->db_blog->getTotalContenidos();

        $articulos=$this->db_blog->getcontenidoPorFecha($pagina, $this->registros_por_pagina);
        
        require_once("vista/Mostrar_Blog.php");
    }

    /**
     * Muestra el formulario para insertar
     */
    public function mostrar_formulario(){
        
        $articulos=$this->db_blog->getcontenidoPorFecha();	
    
        require_once("vista/Formulario.php");
    }

    public function insertar_entrada(){

        if( empty($_POST['titulo']) ) {
            die('error: Titulo no recibido.');
            exit(1);
        }
        if( empty($_POST['comentario']) ) {
            die('error: Comentarios no recibidos.');
            exit(1);
        }

        // Comprobamos la imagen
        if ($_FILES['imagen']['error'] !== UPLOAD_ERR_OK) {
            die("Fallo en la subida. Error: " . $_FILES['file']['error']);
        }
        $info = getimagesize($_FILES['imagen']['tmp_name']);
        if ($info === FALSE) {
            die("No puedo comprobar el tipo de imagen.");
        }
        if (($info[2] !== IMAGETYPE_GIF) && ($info[2] !== IMAGETYPE_JPEG) && ($info[2] !== IMAGETYPE_PNG)) {
            die("No es un gif/jpeg/png");
        }

        // Subimos la imagen
        $dir = 'imagenes/';
        $target_file = $dir . basename($_FILES["imagen"]["name"]);
        
        // Subimos si ya no existe
        if (!file_exists($target_file)) {
            if ( !move_uploaded_file($_FILES["imagen"]["tmp_name"], $target_file )) {
                die( "No se puede subir este archivo" );
            }
        }

        //Insertamos en la bdd
        $_POST['imagen'] = basename($_FILES["imagen"]["name"]);

        $this->db_blog->setInsertarContenido( $_POST );

        // mostramos el listado
        $this->mostrar_blog();
        
    }

}


// Cargamos el modelo y conectamos
require_once("modelo/blog_modelo.php");
	

?>