<?php

class Blog_modelo{
	
	private $db;
	private $contenido = array(); // Guardaremos los artículos del blog

	public function conecta(){
		require_once("modelo/conectar.php");
		$this->db=Conectar::conexion();
		
		return $this->db;
	}

	/**
	 * Retorna el total (número) de contenidos
	 */
	public function getTotalContenidos() {

		$pdo_query = $this->db->query("SELECT count(*) AS total FROM contenido");
		$resultado = $pdo_query->fetchAll(PDO::FETCH_ASSOC);
		return $resultado[0]['total'];
	}


	/**
	 * Retorna todo el contenido ordenado por fecha (el más reciente primero)
	 */
	public function getcontenidoPorFecha($pagina=0, $registros_por_pagina=2){

		if( $pagina > 0 ){
			$pagina = $registros_por_pagina*$pagina;
		}
		
		return $this->db->query("SELECT * FROM contenido ORDER BY fecha DESC LIMIT $pagina,$registros_por_pagina");
	}

	/**
	 * Inserta un nuevo contenido según los datos pasados por array
	 */
	public function setInsertarContenido( $datos ){

		// Comprobamos que se hayan recibido los campos obligatorios de la tabla
		$datos_bd = $this->check_data($datos);
		
		$sql = "INSERT INTO contenido (";
		foreach ($datos_bd as $db_column => $value) {
		  $sql .= substr($db_column, 1).',';
		}
	
		// Quitamos la última coma ','
		$sql = substr($sql, 0, -1);
		
		$sql .= ") VALUES (";
		foreach ($datos_bd as $db_column => $value) {
		  $sql .= $db_column.',';
		}
		
		// Quitamos la última coma ','
		$sql = substr($sql, 0, -1);
		$sql .= ");";
	
		try {
		  $pdo_query = $this->db->prepare($sql);
		  $pdo_query->execute($datos_bd);
		}
		catch(PDOException $e) {
		  echo( 'Falló la inserción:<br>'.$e->getMessage() );
		  exit(1);
		}

		return true;
		
	}


	/**
	 * Comprueba que estén todos los valores para los campos requeridos y los guarda en 
	 */
	private function check_data($data) {
  
	// Campos a recibir
	$array_campos = ['titulo','comentario','imagen'];
  
  
	foreach ($array_campos as $db_column) {
		$ok = false;
	  
		if (isset($data[$db_column])) {
			if (!empty($data[$db_column])) {
				$data_values[':'.$db_column] = $data[$db_column];
				$ok = true;
			}
		}

		if( !$ok ) {
			echo "Error: '$db_column' obligatoria y no recibida.";
			exit(1);
		}

		//insertamos la fecha
		$data_values[':fecha'] = date('Y-m-d H:i:s');
  
	}
  
	  return $data_values;
  }
  


}

?>