window.addEventListener("load", windows_load);

//ejecuciones cuando cargue la página
function windows_load() {

    /**
     * 1o Crea un pequeño programa donde en función de las
     * coordenadas que asignemos, llamaremos a una api que nos dará
     * el índice de calidad del aire. Puedes usar
     * https://openweathermap.org/ en su versión gratuita.
     * Como ejemplo, las coordenadas de Málaga:
     * calidadAire(36.719444,-4.420000);
     */

    // Insertamos el formulario para la latitud y longitud
    calidad_aire_form();


    /**
     * 2o En el mismo index, realizar un ejercicio en el que
     * seleccionaremos un deporte y este nos devolverá otro selector
     * con los distintos materiales necesarios. El material necesario
     * está en el archivo server.php
     */

    selector();
}

/**
 * Genera el formulario para la calidad del aire
 */
function calidad_aire_form() {

    const form = document.createElement('fieldset');
    let element;

    element = document.createElement('legend');
    element.appendChild(document.createTextNode('Introduzca los datos'));
    form.appendChild(element);

    element = document.createElement('label');
    element.setAttribute('for', 'lat');
    element.appendChild(document.createTextNode('Latitud: '));
    form.appendChild(element);

    element = document.createElement('input');
    element.setAttribute('type', 'text');
    element.setAttribute('id', 'lat');
    form.appendChild(element);

    element = document.createElement('div');
    element.style.margin = '5px';
    form.appendChild(element);

    element = document.createElement('label');
    element.setAttribute('for', 'long');
    element.appendChild(document.createTextNode('Longitud: '));
    form.appendChild(element);

    element = document.createElement('input');
    element.setAttribute('type', 'text');
    element.setAttribute('id', 'lon');
    form.appendChild(element);

    element = document.createElement('div');
    element.style.margin = '5px';
    form.appendChild(element);

    element = document.createElement('button');
    element.setAttribute('id', 'calidad_aire_button');
    element.appendChild(document.createTextNode('Calcular calidad de aire'));
    element.addEventListener('click', calidad_aire_calcular);
    form.appendChild(element);


    let element2 = document.createElement('fieldset');
    element2.style.margin = '10px 0';
    element2.style.padding = '5px';
    element2.style.border = '1px solid #333';

    element = document.createElement('legend');
    element.appendChild(document.createTextNode('resultado'));
    element2.appendChild(element);

    element = document.createElement('div');
    element.setAttribute('id', 'calidad_aire_resultado');
    element2.appendChild(element);

    form.appendChild(element2);


    document.querySelector('.ejercicio1').appendChild(form);
}

/**
 * Recoge los datos de latitud y longitud del formulario, hace la petición
 * e inserta el resultado
 * 
 * ******** Esta consulta la hago sin jquery ********
 */
function calidad_aire_calcular() {

    //limpiamos cualquier resultado anterior
    document.querySelector('#calidad_aire_resultado').innerHTML = '';

    const lat = parseFloat(document.querySelector('#lat').value);
    if (!lat) {
        document.querySelector('#calidad_aire_resultado').innerHTML = 'El valor para Latitud no es válido';
        return;
    }
    console.log('lat: ', lat);

    const lon = parseFloat(document.querySelector('#lon').value);
    if (!lon) {
        document.querySelector('#calidad_aire_resultado').innerHTML = 'El valor para Longitud no es válido';
        return;
    }
    console.log('long: ', lon);


    // creamos la petición ajax
    let xmlHttp = new XMLHttpRequest();

    xmlHttp.onreadystatechange = () => {
        if (xmlHttp.readyState === 4) { // hemos recibido la respuesta
            if (xmlHttp.status === 200) { // La respuesta es correcta

                var datos = JSON.parse(xmlHttp.responseText);
                console.log('datos recibidos: ', datos);

                let resultado = '<table cellspacing="10">'
                    + '<thead><tr><td>Calidad</td><td>SO<sub>2</sub></td><td>NO<sub>2</sub></td>'
                    + '<td>PM<sub>10</sub></td><td>PM<sub>2.5</sub></td><td>O<sub>3</sub></td>'
                    + '<td>CO</td></tr></thead><tbody><tr>';

                switch (datos.list[0].main.aqi) {
                    case 1:
                        resultado += '<td>1 - Buena</td>';
                        break;
                    case 2:
                        resultado += '<td>2 - Justa</td>';
                        break;
                    case 3:
                        resultado += '<td>3 - Moderada</td>';
                        break;
                    case 4:
                        resultado += '<td>4 - Pobre</td>';
                        break;
                    case 5:
                        resultado += '<td>5 - Muy pobre</td>';
                        break;
                    default:
                        resultado += '<td>sin datos</td>';
                }

                resultado += '<td>' + datos.list[0].components.so2 + '</td>';
                resultado += '<td>' + datos.list[0].components.no2 + '</td>';
                resultado += '<td>' + datos.list[0].components.pm10 + '</td>';
                resultado += '<td>' + datos.list[0].components.pm2_5 + '</td>';
                resultado += '<td>' + datos.list[0].components.o3 + '</td>';
                resultado += '<td>' + datos.list[0].components.co + '</td>';
                resultado += '</tr></tbody></table>';

                document.querySelector('#calidad_aire_resultado').innerHTML = resultado;

            } else {

                document.querySelector('#calidad_aire_resultado').innerHTML = 'Ocurrió algún error.';
            }
        }
    }


    let url = 'https://api.openweathermap.org/data/2.5/air_pollution/forecast?'
        + '&units=metric&lang=es_es&appid=500857843447dd929fe60dd1e5efba1a'
        + '&lat=' + lat
        + '&lon=' + lon;

    xmlHttp.open("GET", url, true);
    xmlHttp.send();

}


/**
 * Ejercicio 2
 */

function selector() {

    const deportes = $('select[name=deportes]');
    const materiales = $('select[name=materiales]');

    deportes.on('change', function() {
        
        const deporte = $(this).val();

        if (deporte > '0' && deporte <= 3) {
            
            $('#cargando').html('Cargando datos...');

            $.ajax({

                type: 'GET',
                url: 'php/server.php',
                dataType: 'xml',
                data: {
                    cod: deporte
                },

            }).done( (xml) => {

                materiales.empty();
                $('#cargando').html('');

                $(xml).find('material').each( function() {
                    materiales.append('<option>' + $(this).text() + '</option>');
                });

            }).fail(function () {
                
                $('#cargando').html('Error al cargar los materiales.');

            });
        
        } else {

            // limpiamos el select de los materiales
            materiales.empty();
        
        }
    });


}