$(document).ready(function () {

    /**
     * 1. Crea una lista de elementos en HTML y usa jQuery para
    cambiar su estilo y recorrerlos. Al hacer clic en un
    elemento, se debe resaltar cambiando su color de fondo a
    amarillo. Al hacer clic nuevamente en el mismo elemento,
    el color de fondo debe volver a su estado original.
    Además, cuando el cursor se mueve sobre un elemento, su
    color de fuente debe cambiar a rojo (3 pts).
    */

    $('ul li').each(function () {

        //Generamos un color aleatorio (grupo de 6 dígitos hexadecimales)
        var digitos = '0123456789ABCDEF';
        var color = '#';
        for (var i = 0; i < 6; i++) {
            color += digitos[Math.floor(Math.random() * 16)];
        }
        $(this).css('color', color);

        $(this).click(function (e) {
            $(this).toggleClass('resaltado');
        });

        $(this).hover(function () {
            $(this).css("color", "red");
        }, function () {
            $(this).css("color", color);
        });


    });


    /**
     * 2. Desarrollar un sistema que permita seleccionar una
    categoría de productos desde un menú desplegable y que
    muestre en otro menú desplegable los productos
    disponibles de esa categoría. Para ello, se utilizará un
    menú desplegable para seleccionar la categoría y otro
    menú desplegable para mostrar los productos, además de un
    mensaje de "cargando" con el gif que está en la carpeta
    css mientras se realiza la petición al servidor.
    
    Los datos de las categorías y productos se obtendrán de
    un servidor PHP que devolverá un archivo XML con la
    información correspondiente. Se utilizará jQuery para
    realizar la petición AJAX al servidor y mostrar los datos
    en la página HTML (4 pts).
     */

    const productos = $('select[name=productos]');
    const productos_disponibles = $('select[name=productos-disponibles]');

    $('#cargando').css('display', 'none');
    $('#cargando').html('<img src="css/loading.gif" />');

    productos.on('change', function () {

        const producto = $(this).val();

        if (producto > '0') {

            //se vuelve a insertar por si hay un error previo
            $('#cargando').html('<img src="css/loading.gif" />');
            
            $('#cargando').css('display', 'block');

            $.ajax({

                type: 'GET',
                url: 'php/server.php',
                dataType: 'xml',
                data: {
                    cat: producto
                },

            }).done((xml) => {

                productos_disponibles.empty();
                $('#cargando').css('display', 'none');

                $(xml).find('producto').each(function () {
                    productos_disponibles.append('<option>' + $(this).text() + '</option>');
                });

            }).fail(function () {

                $('#cargando').css('display', 'block');
                $('#cargando').html('Error al cargar los productos.');

            });

        } else {

            // limpiamos el select de los materiales
            productos_disponibles.empty();

        }
    });


    /**
     * 3. Analizar el archivo xml “pelis.xml” a través de una
    petición con el objeto XMLHttpRequest y devuelve la
    información en la web de la siguiente manera (3 pts):
     */

    // creamos la petición ajax
    let ajax = new XMLHttpRequest();

    ajax.onreadystatechange = () => {
        if (ajax.readyState === 4) { // hemos recibido la respuesta
            if (ajax.status === 200) { // La respuesta es correcta

                const datos = ajax.responseXML;

                //console.log('datos raw: ', ajax.responseText);
                console.log('datos parse: ', datos);

                const movies = datos.querySelectorAll('Movie');
                console.log('movie: ', movies);
                console.log('movie0: ', movies[0]);
                console.log('title: ', movies[0].querySelector('Title').innerHTML);

                let section;
                let element;

                movies.forEach(function (value, index, array) {

                    section = document.createElement('section');
                    section.style.margin = '50px 0';

                    element = document.createElement('h2');
                    element.appendChild( document.createTextNode( 'Título: ' + value.querySelector('Title').innerHTML )) ;
                    section.appendChild(element);
                    
                    element = document.createElement('p');
                    element.appendChild( document.createTextNode( 'Año: ' + value.querySelector('Year').innerHTML )) ;
                    section.appendChild(element);
                    
                    element = document.createElement('p');
                    element.appendChild( document.createTextNode( 'Director: ' + value.querySelector('Director').innerHTML )) ;
                    section.appendChild(element);
                    
                    element = document.createElement('p');
                    element.appendChild( document.createTextNode( 'Compañía de producción: ' + value.querySelector('ProductionCompany').innerHTML )) ;
                    section.appendChild(element);
                    
                    element = document.createElement('p');
                    element.appendChild( document.createTextNode( 'Reparto:') );
                    
                    let actors = document.createElement('ul');

                    value.querySelectorAll('Cast Actor').forEach( function(actor_value) {

                        let actor = document.createElement('li');
                        actor.appendChild( document.createTextNode( 
                            actor_value.querySelector('Name').innerHTML + ' como ' + actor_value.querySelector('Role').innerHTML
                        ) );

                        actors.appendChild(actor);
                    });
                    
                    element.appendChild(actors);

                    section.appendChild(element);
                    
                    document.querySelector('.ejercicio3').appendChild(section);

                });

            } else {

                $('.ejercicio3').html('Error al cargar pelis.xml');

            }
        }
    }

    let url = 'pelis.xml';

    ajax.open("GET", url, true);
    ajax.send();

});