// https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API/Using_Fetch

document.querySelector('form').addEventListener('submit', function (ev) {
    ev.preventDefault();
    
    let ahora = new Date();
    let url = "php/print-post-json.php"

    let div = document.querySelector('pre#form');

    json_data = {
        nombre: document.querySelector("input[name=query]").value,
        fecha: ahora,
        lenguaje: navigator.language,
    }

    let post_data = new FormData();
    post_data.append('nombre', document.querySelector("input[name=query]").value);
    post_data.append('fecha', ahora);
    post_data.append('lenguaje', navigator.language);

    const options = {
        method: "POST",
        body: JSON.stringify(json_data)
        //body: post_data
    }

    console.log('options: ', options);

    fetch(url, options)
        .then((response) => {
            if (response.ok) {
                console.log('response', response);
                return response.json();
                //return response.text();
            } else {
                throw new Error("Ocurrió un error al enviar los datos");
            }
        })
        .then((text) => {
            console.table(text);
            console.log('data: ', text);
            div.textContent = text;
        })
        .catch((error) => {
            console.log('Error: ', error);
        });

});

document.querySelector('button').addEventListener('click', () => {

    fetch(
        'https://raw.githubusercontent.com/FRomero999/ExamenDIW2022/main/clientes.json',
        { method: 'get' })
        .then((response) => {
            if (response.ok) {
                console.log('response', response);
                return response.json();
            } else {
                throw new Error("Ocurrió un error al obtener el json");
            }
        })
        .then((data) => {
            console.log('Datos: ', data);

            let div = document.querySelector('div#cargar');

            data.forEach(element => {

                let ul = document.createElement('ul');

                Object.entries(element).forEach(([key, value]) => {

                    let li = document.createElement('li');
                    li.appendChild(document.createTextNode(key + ': ' + value));
                    ul.appendChild(li);

                });
                div.appendChild(ul);

            });
            //.innerHTML = data.join(' ');
        })
        .catch((error) => {
            console.log('Error: ', error);
        });

});