let button = document.querySelector('button');
var map = L.map('map');
var popup = L.popup();
var latitude;
var longitude;

var geo_options = {
    enableHighAccuracy: true,
    maximumAge: 30000,
    timeout: 27000
}

window.addEventListener("load", () => {

    map.setView([40.4165000, -3.7025600], 6);

    L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 19,
        attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
    }).addTo(map)

});

button.addEventListener('click', () => {

    navigator.geolocation.getCurrentPosition(
        (coordenadas) => {
            console.log(coordenadas);

            latitude = coordenadas.coords.latitude;
            longitude = coordenadas.coords.longitude;

            map.setView([latitude, longitude], 17);
            popup.setLatLng([latitude, longitude])
                .setContent('Usted está aquí<br>Longitud: ' + longitude + '<br>Latitud: ' + latitude)
                .openOn(map);

        },
        (error) => {
            console.log(error);
            main.innerText = 'Error al acceder a la localización';
        },
        geo_options
    );

});

map.addEventListener('contextmenu', (e) => {
    //popup.close();

    e.originalEvent.preventDefault();
    console.log('e', e);
    latitude = e.latlng.lat;
    longitude = e.latlng.lng;

    popup.setLatLng([latitude, longitude])
        .setContent('Longitud: ' + longitude + '<br>Latitud: ' + latitude)
        .openOn(map);
    

});