<?php
/**
 * Crear un formulario con 2 input donde ponder escribir un número en cada uno de ellos.
 * También habrá un desplegable en el formulario (select) para elegir una de las siguientes
 * operaciones matemáticas: suma, resta, multiplicar, dividir y modulo.
 * 
 * El formulario deberá tener también un botón que ponga “calcular” y que llamará a otro archivo
 * php que tendrá las funciones necesarias para realizar el cálculo solicitado.
 * Y mostrará el resultado en pantalla de la siguiente forma: (ejemplo)
 * 	“El resultado de la operación MULTIPLICAR es: RESULTADO”
 * 
 * Este texto aparecerá en pantalla en color rojo y tamaño 14px.
 * 
 * Tened en cuenta que el programa pueda “reconocer” si son valores numéricos los que se introducen
 * para lanzar el cálculo o saque un mensaje indicando que los valores introducidos no son válidos.
 * El archivo del formulario se llamará “formularioCalcular.php” y el archivo que realiza las
 * operaciones y muestra los resultados se llamará “calculodelformulario.php”
 */


$out = ''; //definimos una variable para guardar lo que hay que mostrar
$error = false; //controla si hay algún error para no calcular
// Comprobamos si se ha recibido algún post

if( !empty( $_POST ) ) {

  // Comprobamos si se han recibido los valores y son correctos
  if( !empty($_POST['values'][0]) && !empty($_POST['values'][1]) && !empty($_POST['operator']) ) {
    
    $values = $_POST['values'];
    $operator = $_POST['operator'];

    if( !is_numeric($values[0]) ) {
      //probamos a reemplazar la coma (si la hay) por un punto
      $values[0] = str_replace(',', '.', $values[0]);
      if( !is_numeric($values[0]) ) {
        $error = true;
        $out .= '<p class="error">Error: El primer valor ('.$_POST['values'][0].') no es un número.</p>';
      }
    }
    
    if( !is_numeric($values[1]) ) {
      //probamos a reemplazar la coma (si la hay) por un punto
      $values[1] = str_replace(',', '.', $values[1]);
      if( !is_numeric($values[1]) ) {
        $error = true;
        $out .= '<p class="error">Error: El segundo valor ('.$_POST['values'][1].') no es un número.</p>';
      }
    }
    
    if( !$error ) {
      switch( $operator) {
        case '+':
          $out .= '<p class="resultado">
                    El resultado de sumar '.$_POST['values'][0].' y '.$_POST['values'][1].' es: <span>'
                    .($values[0] + $values[1]).'</span></p>';
          break;
        case '-':
          $out .= '<p class="resultado">
                    El resultado de restar '.$_POST['values'][0].' menos '.$_POST['values'][1].' es: <span>'
                    .($values[0] - $values[1]).'</span></p>';
          break;
        case '*':
          $out .= '<p class="resultado">
                    El resultado de multiplicar '.$_POST['values'][0].' por '.$_POST['values'][1].' es: <span>'
                    .($values[0] * $values[1]).'</span></p>';
          break;
        case '/':
          $out .= '<p class="resultado">
                    El resultado de dividir '.$_POST['values'][0].' entre '.$_POST['values'][1].' es: <span>'
                    .($values[0] / $values[1]).'</span></p>';
          break;
        case '%':
          $out .= '<p class="resultado">
                    El resto de dividir '.$_POST['values'][0].' entre '.$_POST['values'][1].' es: <span>'
                    .($values[0] % $values[1]).'<span></p>';
          break;
        default:
          $error = true;
          $out .= '<p class="error">Error: No se ha seleccionado un operador.</p>';
      }
    }

  } else {
    $out .= '<p class="error">Error: No se han recibido datos.</p>';
  }

} else {
  $out .= '<p class="error">Error: No se han recibido datos.</p>';
}


?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title>TAREA 2DAW - ENTORNO SERVIDOR - ARRAY CALCULAR CONEXION BBDD</title>
  <style>
    html {
      font-size: 14px;
    }

    body {
      margin: 0;
      font-family: Arial, Helvetica, sans-serif;
    }

    .enunciado {
      background-color: #ccc;
    }

    p {
      font-weight: normal;
      margin: 10px 0;
    }

    main {
      margin-bottom: 45px;
    }

    main>* {
      padding: 15px;
    }

    .resultado { font-size: 1em; }
    .resultado span {
      font-size: 14px;
      color: red;
      font-weight: 600;
    }

    a { color: black; }
    
    .error {
      padding: 10px;
      background-color: rgb(171, 0, 0);
      color: white;
      border-radius: 5px;
    }

    .error a { color: white; }

    footer {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      line-height: 1rem;
      text-align: center;
      background-color: #333;
      color: #eee;
    }
  </style>
</head>

<body>
  <main>
    <div class="enunciado">
      <p>Crear un formulario con 2 input donde ponder escribir un número en cada uno de ellos.
        También habrá un desplegable en el formulario (select) para elegir una de las siguientes
        operaciones matemáticas: suma, resta, multiplicar, dividir y modulo.</p>

      <p>El formulario deberá tener también un botón que ponga “calcular” y que llamará a otro archivo
        php que tendrá las funciones necesarias para realizar el cálculo solicitado.
        Y mostrará el resultado en pantalla de la siguiente forma: (ejemplo)</p>
      <p style="padding: 10px;">“El resultado de la operación MULTIPLICAR es: RESULTADO”</p>
      <p>Este texto aparecerá en pantalla en color rojo y tamaño 14px.</p>
      <p>Tened en cuenta que el programa pueda “reconocer” si son valores numéricos los que se introducen
        para lanzar el cálculo o saque un mensaje indicando que los valores introducidos no son válidos.</p>
      <p>El archivo del formulario se llamará “formularioCalcular.php” y el archivo que realiza las operaciones
        y muestra los resultados se llamará “calculodelformulario.php”</p>
    </div>
    <div class="resolucion">
      <?php echo $out; ?>
      <p><a href="javascript:history.back()">volver</a></p>
    </div>
  </main>
  <footer>
    <p>Miguel Carmona - 2ºDAW</p>
  </footer>
</body>

</html>