<?php

/** 
 * Crear una base de datos llamada “pruebas” y una tabla dentro de ella que se llame
 * “productos”. Dicha tabla se ha pasado por el chat del equipo y la podréis importar
 * desde phpmyadmin o por consola de comandos.
 * 
 * Crea un formulario de búsqueda.
 * 
 * El usuario pondrá poner el nombre de un artículo de la tabla o palabra que lo contenga y
 * al darle al botón “Dale!” se llamará al archivo “pagina_busqueda.php” que realizará la
 * conexión con la base de datos, realizará la consulta correspondiente SELECT y mostrará
 * los resultados en pantalla
 */

// comprobamos si se ha recibido una búsqueda
if( !empty($_GET['search']) ) {

    // Limpiamos posible inyección XSS
    $search = htmlentities($_GET['search']);

    // Activamos mostrar errores de mysql:
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

    // Creamos el objeto de conexión a la bdd
    $mysql_connect = new mysqli('localhost', 'entornoservidor', 'Rc3RiEsbP$D1RjKS', 'entornoservidor');

    if ($mysql_connect->connect_errno) {
        throw new RuntimeException('mysqli connection error: ' . $mysql_connect->connect_error);
    }

    // Establecemos la codificación a utilizar en la bdd
    $mysql_connect->set_charset('utf8mb4');
    if ($mysql_connect->errno) {
        throw new RuntimeException('mysqli error: ' . $mysql_connect->error);
    }

    /**
     * Este método de consulta es más complejo pero seguro ya que enviamos la consulta y nos devuelve un manejador
     * para poder enviar cadenas externas (indicando que es un string 's'). Esto nos permite un nivel de seguridad
     * superior al ser el mismo servidor de bdd el que maneja que hay un string a buscar y evita inyección sql.
     * 
     * Por ejemplo, aquí se explica más detallado: https://diego.com.es/sentencias-preparadas-en-php
     */
    
    // Si se reciben parámetros de orden
    
    if( !empty($_GET['order_by']) && !empty($_GET['order']) ) {
      
        $order = 'asc';
        
        // Comprobamos que el orden tenga valores válidos
        $valid_order = ['asc', 'desc'];
        if( in_array( strtolower( $_GET['order'] ), $valid_order ) ) {
          
          $order = strtolower( $_GET['order'] );

          // Ya que el orden es correcto, vamos a obtener las cabeceras de la tabla para comprobar el campo a ordenar
          $mysql_query = $mysql_connect->query('SHOW COLUMNS FROM productos');
          $result = $mysql_query->fetch_all(MYSQLI_ASSOC);
          foreach( $result as $line ) {
            $valid_order_by[] = strtolower($line['Field']);
          }

          // Comprobamos si el la columna a ordenar coincide con alguna columna
          if( in_array( strtolower( $_GET['order_by'] ), $valid_order_by ) ) {
            $order_by = strtolower( $_GET['order_by'] );
          }
       } 
    }

   
    // Preparamos la consulta
    if( !empty($order) && !empty($order_by) ) {
      $mysql_query = $mysql_connect->prepare('SELECT * FROM productos WHERE `nombrearticulo` LIKE ? ORDER BY '.$order_by.' '.$order);
    } else {
      $mysql_query = $mysql_connect->prepare('SELECT * FROM productos WHERE `nombrearticulo` LIKE ?');
    }
    
    // Preparamos y enviamos la cadena de búsqueda
    $search = '%'.$search.'%';
    $mysql_query->bind_param('s', $search);
    
    // Lanzamos la consulta
    $mysql_query->execute();
    
    // Obtenemos los resultados
    $mysql_result = $mysql_query->get_result();
    
    // Guardamos los resultados como array asociativo
    $data = $mysql_result->fetch_all(MYSQLI_ASSOC);




    //$result = $mysql_query->result_metadata();

    //var_dump($result = $mysql_query->result_metadata());
/*    
    //cabecera
    while ( $line = $result->fetch_field() ) {
       var_dump($line);
    } 
*/
    //datos
    //var_dump( $mysql_query->fetch_array() );
    /*while ( $stmt->fetch() ) {
        var_dump($line);
    }*/


}
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title>TAREA 2DAW - ENTORNO SERVIDOR - ARRAY CALCULAR CONEXION BBDD</title>
  <style>
    html {
      font-size: 14px;
    }

    .center { text-align: center; }

    body {
      margin: 0;
      font-family: Arial, Helvetica, sans-serif;
    }

    .enunciado {
      background-color: #ccc;
    }

    .enunciado p {
      font-weight: normal;
      margin: 10px 0;
    }

    .error {
      padding: 10px;
      background-color: rgb(171, 0, 0);
      color: white;
    }

    main {
      margin-bottom: 45px;
    }

    main>* {
      padding: 15px;
    }

    .resolucion {
      padding-top: 0px;
    }

    form {
      position: sticky;
      top: -1px;
      background-color: white;
      padding-top: 15px;
      padding-bottom: 15px;
    }

    input {
      font-size: 1.2em;
      width: 300px;
      padding: 5px;
      margin: 5px;
    }
    input[type=submit] {
        width: 100px;
    }

    main table {
      border-collapse: collapse;
      margin: 0 auto 15px auto;
    }
    main table thead {
      position: sticky;
      top: 72px;
    }
    main table thead th {
      background-color: #ccc;
    }
    main table thead th a {
      color: black;
      text-decoration: none;
    }
    main table thead th.asc a::before {
      content: '\1F815 \0020';
      line-height: 1rem;
    }
    main table thead th.asc a::after {
      content: '\0020 \1F815';
      line-height: 1rem;
    }
    main table thead th.desc a::before {
      content: '\1F817 \0020';
      line-height: 1rem;
    }
    main table thead th.desc a::after {
      content: '\0020 \1F817';
      line-height: 1rem;
    }
    main table thead th, main table td {
      border: 1px solid #aaa;
      padding: 5px;
      overflow-wrap: anywhere;
    }

    footer {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      line-height: 15px;
      text-align: center;
      background-color: #333;
      color: #eee;
    }
  </style>
</head>

<body>
  <main>
    <div class="enunciado">
      <p>Crear una base de datos llamada “pruebas” y una tabla dentro de ella que se llame
        “productos”. Dicha tabla se ha pasado por el chat del equipo y la podréis importar
        desde phpmyadmin o por consola de comandos.</p>
      <p>Crea un formulario de búsqueda.</p>
      <p>El usuario pondrá poner el nombre de un artículo de la tabla o palabra que lo contenga y
        al darle al botón “Dale!” se llamará al archivo “pagina_busqueda.php” que realizará la
        conexión con la base de datos, realizará la consulta correspondiente SELECT y mostrará
        los resultados en pantalla</p>
    </div>
    <div class="resolucion center">
      <form action="pagina_busqueda.php" method="get">
        <input type="text" name="search" placeholder="Introduce un artículo a buscar" <?php
          if( !empty($_GET['search']) ) echo 'value="'.$_GET['search'].'"';
        ?> />
        <input type="submit" value="Dale!" />
      </form>
      <?php
      if( !empty($data) ) {
        echo "<table>\n<thead>\n\t<tr>";

        // Fijamos los órdenes y comprobamos si hay algún orden
        $ordered = false;
        $query_order = 'asc';
        if( !empty($order) && !empty($order_by) ) {
          $ordered = true;
          if( $order == 'asc' ) {
            $query_order = 'desc';
          }
        }

        // Recorremos la primera fila para obtener las cabeceras
        foreach( $data[0] as $key=>$value ) {
          
          // Comprobamos si se está ordenando por esta columna
          if( $ordered && $order_by == strtolower($key) ) {
            echo "\n\t\t<th class=\"$query_order\"><a href=\"?search=".$_GET['search']."&order_by=$key&order=$query_order\">$key</a></th>";
          } else {
            echo "\n\t\t<th><a href=\"?search=".$_GET['search']."&order_by=$key&order=$query_order\">$key</a></th>";
          }
        }

        echo "\n</thead>\n\t</tr>\n<tbody>";
        
        // Recorremos las filas
        foreach( $data as $item ) {
          echo "\n\t</tr>";
          
          // Recorremos los campos
          foreach( $item as $value ) {

            echo "\n\t\t<td>$value</td>";

          }
          
          echo "\n\t</tr>";
        }
        echo '</tbody></table>';
        echo '<p>*pulse sobre alguna cabecera para ordenar</p>';
      } else {
        echo '<p>Sin resultados</p>';
      }
      ?>
    </div>
  </main>
  <footer>
    <p>Miguel Carmona - 2ºDAW</p>
  </footer>
</body>

</html>
